# Learning UI-to-Code Reverse Generator using Visual Critic without Rendering

## Abstract

Automated reverse engineering of HTML/CSS code from UI screenshots is an important yet challenging problem with broad applications in website development and design. In this paper, we propose a novel vision-code transformer (ViCT) composed of a vision encoder processing the screenshots and a language decoder to generate the code. They are initialized by pre-trained models such as ViT/DiT and GPT-2/LLaMA but aligning the two modalities requires end-to-end finetuning, which aims to minimize the visual discrepancy between the code-rendered webpage and the original screenshot. However, the rendering is non-differentiable and causes costly overhead. We address this problem by actor-critic fine-tuning where a visual critic without rendering (ViCR) is developed to predict visual discrepancy given the original and generated code. To train and evaluate our models, we created two synthetic datasets of varying complexity, with over 75,000 unique (code, screenshot) pairs. We evaluate the UI-to-Code performance using a combination of automated metrics such as MSE, BLEU, IoU, and a novel htmlBLEU score. ViCT outperforms a strong baseline model DiT-GPT2, improving IoU from 0.64 to 0.79 and lowering MSE from 12.25 to 9.02. With much lower computational cost, it can achieve comparable performance as when using a larger decoder such as LLaMA.

## Contributions
- Development of a novel vision-code transformer (ViCT) for the automated reverse engineering of HTML/CSS code from UI screenshots.
- Utilization of a visual critic to enhance the performance of the ViCT without the need for rendering.
- A comprehensive evaluation of the proposed method, demonstrating its effectiveness in website development and design applications.

## Code Structure
- `critic_trainer.py`: Module for training the visual critic.
- `synthetic_base_generator.py`: Utility for generating RUID data.
- `test_dataloader.py`: Data loading for testing the model.
- `models.py`: Contains the implementation of the vision-code transformer (ViCT).
- `evaluating_samples_by_complexity.py`: Script for evaluating generated samples by their complexity.
- `HTMLBleuScore.py`: Utility for computing the BLEU score for the generated HTML.
- `critic_inference.py`: Inference script for the visual critic.
- `critic_tuning.py`: Script for fine-tuning the visual critic.
- `language_detector.py`: Utility for detecting the language used in the generated code.
- `trainer_l.py`: Trainer script for the language detection model.
- `dataloader.py`: Data loading utilities for training and evaluation.
- `trainer.py`: Main training script for the ViCT model.
- `evaluator.py`: Script for evaluating the performance of the trained models.
